#import "@preview/subpar:0.2.2"
#import "@preview/cetz:0.3.4": canvas, draw
#import "../utils/blocks.typ": *
#import "@preview/theorion:0.3.3": *
#import cosmos.simple: *
#show: show-theorion

#set text(lang: "en")
#set math.equation(numbering: none)

#let cost = math.op("cost")
#let val = math.op("val")
#let rellr(l, r) = {
  math.op(eval("$->_(" + l + ",R," + r + ")$"))
}

#let rell(l) = {
  math.op(eval("$->_(" + l + ",R)$"))
}

#let relr(r) = {
  math.op(eval("$->_(R," + r + ")$"))
}
#let rel() = math.op($->_R$)

#let torel = math.op("rel")

#let downlr(l, r) = {
  math.op(eval("$->_(" + l + ",D," + r + ")$"))
}

#let downl(l) = {
  math.op(eval("$->_(" + l + ",D)$"))
}

#let downr(r) = {
  math.op(eval("$->_(D," + r + ")$"))
}

#let down() = math.op(eval("$->_D$"))
#let hide = math.op("hide")
#let rem = math.op("rem")
#let bay = math.op("Bay")
#let add = math.op("add")
#let free = math.op("free")

#set heading(numbering: "1.")

= Introduction <intro>

In this section we give all the formal definitions needed
to prove that the heuristic $L$ is worst-case optimal.
We suppose that $N,W,H in NN$ are given constants which
are the initial number of containers, the number of stacks
and the maximal height of the stacks. Note that we must have
$N < W dot H$ for the game to be feasible, else no container
could be relocated.

To define the game, we first have to define a state
for both players, i.e. player $1$ which is relocating
the containers and player $2$ which is asking for containers
to retrieve. Intuitively, states for player $1$ are just a given
configuration of the bay, which can be represented by a single
vector whose components are the heights of the stacks. Yet we will prefer a set of coordinates, which is easier to manipulate. For the player $2$, it is a configuration of the bay and coordinates of the asked container. Yet this container must be
high enough to there is enough free space for player $1$ to move
every container above it. This is formally defined in @def_states.

#definition(title: "states and notations")[
  - We call $bay = [|1,W|] times [|1,H|]$ the set of coordinates in the bay.
  - $Q_2$, the set of states of the player $2$, is composed of every $s subset.eq bay$ such that for all $1 <= i <= W, 1 < j <= H$, $(i,j) in s => (i,j - 1) in s$
  - for any $s in Q_2$ and $1 <= i <= W$, we call $h_i (s) = |{(a,b) in s | a = i}|$ the height of the stack $i$.
  - $Q_1$, the set of states of the player $1$, is composed of every $s^(i,j) = (s,i,j) in Q_2 times bay$ such that $1 <= j <= h_i (s)$ (player $2$ must request a container, not an empty space) and $(W - 1) dot H >= |s| - j$ (player $1$ must have enough free space to move the containers above the requested one).
  - For any $s^(i,j) in Q_1$, the number of containers player $1$ has to relocate only depends on the state, its value is $h_i (s) - j$ and is denoted by $torel(t^(i,j))$
] <def_states>

#example()[
  Let us consider $a_1 = {(1,1),(2,1),(3,1),(1,2),(3,2)}$ in a bay of width $W = 3$ and height $H = 3$, a representation of $a_1$ is given in @imex1a. If the bottom left container is requested, we get the state $a_1^(1,1)$ given in @imex1b, the requested container is the one with a dot in it.
]

#let imex1a = im_blocks((
  (
    (2, 1, 2),
    none-style(),
  ),
))

#let imex1b = im_blocks((
  (
    (1, 0, 0),
    request(),
  ),
  (
    (1, 1, 2),
    none-style(),
  ),
))

#let imex1c = im_blocks((
  (
    (2, 0, 0),
    none-style(stroke_ext: (dash: "dashed")),
  ),
  (
    (0, 1, 3),
    none-style(),
  ),
))

#subpar.grid(
  figure(imex1a, caption: [The state $a_1$]), <imex1a>, figure(imex1b, caption: [The state $a_1^(1,1)$]),
  <imex1b>, figure(imex1c, caption: [The state $a_2$]), <imex1c>,
  columns: (1fr, 1fr, 1fr),
  caption: [Representation of basic configurations],
  label: <ex1>,
)

We need to define some notations to make it easier to manipulate movements of containers between the stacks, it can be adding a container, removing/retrieving one, or relocating it from a stack to another.

#definition(title: "retrieve - relocation")[
  - We start by giving a notation for the addition of a container on top of a stack. Given $s in Q_2$ and $1 <= i <= W$ such that $h_i (s) <= H$, we denote by $add_i (s) = s union {(i,h_i (s) + 1)}$ the obtained configuration.
  - Similarly if $h_i (s) > 0$, we denote by $rem_i (s) = s \\ {(i, h_i (s))}$ the configuration obtained by removing the top container of stack $i$.
  - For any $1 <= i,j <= W$ and $s in Q_2$, if $h_i (s) < H$, $h_j (s) < H$ and $i eq.not j$ we say that $add_i (s)$ relocates to $add_j (s)$, which we denote by $add_i (s) rellr("i", "j") add_j (s)$. It also naturally gives us by induction $rellr("i", "j")^k$ and the transitive closure $rellr("i", "j")^*$. We also define the value of $i,j$ is known the three relations $rel(),rell("i"),relr("j")$
]

These help us defining the so-called transition of the game, intuitively, player $2$ just have to keep the same state and add coordinates of the container he wants to request, and player $1$ has to move the $torel(s^(i,j))$ containers above the requested one and then (or before) retrieve it.

#definition(title: "CRP transition")[
  For any two states $s in Q_2, t^(i,j) = (t,i,j) in Q_1$ we have :
  - $s --> t^(i,j)$ if and only if $s = t$
  - $t^(i,j) --> s$ if and only if $rem_i (t) rell("i")^(torel(t^(i,j))) s$
]

#example()[
  We also consider the state $a_2 = add_3(rem_1^2 (a_1))$ which verifies $a_1^(1,1) --> a_2$, represented in @imex1c, the previous position of relocated or retrieved containers is dashed.
]


#definition(title: "CRP game")[
  Given $N,H,W in NN$, the CRP game $G$ is defined as the tuple $(Q_2,Q_1,-->)$. We also call $G_s$ CRP game starting is the state $s in Q_1 union Q_2$
] <thm:game>

The next step is to introduce strategies, in this section, the considered strategies for both player are adaptative, memoryless and deterministic.

#definition(title: "strategies")[
  A strategy for player $1$ is a mapping $sigma : Q_1 -> Q_2$ such that for any $s^(i,j) in Q_1$, $s^(i,j) --> sigma(s^(i,j))$. Respectively, a strategy for player $2$ is a mapping $pi : Q_2 -> Q_1$ such that for any $s in Q_2$, $s --> pi(s)$. We call $Sigma,Pi$ the set of strategies of player $1$ and $2$.
]

When both players fix a strategy and an initial state is given,
it induces a play, which is a sequence of requests and retrieves.
The cost of this play is the number of relocations made by player
$1$. A play is necessarly finite and converges to the state with
no containers, since any move from player $1$ removes one
container.

#definition(title: "play, value of a play")[
  Given an initial state $u in Q_1 union Q_2$ and two strategies
  $sigma in Sigma, pi in Pi$. A play $s --> s_1 --> ... --> s_K = emptyset$ is induced. The cost of this play is the number of relocations, i.e. $sum_(0 <= k <= K\ s_k in Q_1) torel(s_k)$ We call this value $val_(sigma,pi)(s)$.
]

#let imex2a = im_blocks((
  (
    (1, 0, 0),
    request(),
  ),
  (
    (2, 1, 1),
    none-style(),
  ),
))

#let imex2b = im_blocks((
  (
    (3, 0, 0),
    none-style(stroke_ext: (dash: "dashed")),
  ),
  (
    (0, 0, 1),
    request(),
  ),
  (
    (0, 2, 1),
    none-style(),
  ),
))

#let imex2c = im_blocks((
  (
    (0, 0, 2),
    none-style(stroke_ext: (dash: "dashed")),
  ),
  (
    (0, 1, 0),
    none-style(),
  ),
  (
    (0, 1, 0),
    request(),
  ),
  (
    (0, 1, 0),
    none-style(),
  ),
))

#let imex2d = im_blocks((
  (
    (1, 1, 1),
    none-style(),
  ),
  (
    (0, 2, 0),
    none-style(stroke_ext: (dash: "dashed")),
  ),
))

#subpar.grid(
  figure(imex2a, caption: [The state $b_1^(1,1)$]),
  <imex2a>,
  figure(imex2b, caption: [The state $b_2^(3,1)$]),
  <imex2b>,

  figure(imex2c, caption: [The state $b_3^(2,2)$]), <imex2c>, figure(imex2d, caption: [The state $b_4$]), <imex2d>,
  columns: (1fr, 1fr, 1fr, 1fr),
  caption: [Representation of a play of value $4$],
  label: <ex2>,
)

#example()[
  Let us consider $b_1 = {(1,1),(1,2),(1,3),(2,1),(3,1)}$. We consider the play $b_1 --> b_1^(1,1) --> b_2 --> b_2^(3,1) --> b_3 --> b_3^(2,2) --> b_4 --> ...$. From $b_1$ to $b_4$, the value of the play is obtained by counting the number of relocations, hence it is $torel(b_1^(1,1)) + torel(b_2^(3,1)) + torel(b_3^(2,2)) = 2 + 1 + 1 = 4$. By noticing that the induced cost from $b_4$ must be zero, and noting $sigma_0,pi_0$ some strategies inducing this play, we get $val_(sigma_0,pi_0)(b_1) = 4$
]


















= Optimal strategies <optimal_strat>

Player $1$ wants to minimise the value of the play, so a good
strategy can be seen as minimising the maximal value player $2$
can ensure. We introduce strategies for both player, which are intuitively good, we will later prove that these are optimal in the deterministic worst-case setting.

#definition(title: "strategies L & F")[
  - The strategy $L$ for player $1$ consists in relocating the containers one by one in the smallest stack. When multiple stacks are available, it chooses the leftmost one.
  - The strategy $F$ for player $2$ consists in requesting the bottom container of the biggest stack. If is not possible, it asks for the lowest possible container of this same stack. If several stacks have a maximal height, then it chooses the rightmost one.
]

#let imex3a = custom_im_blocks(
  (
    (
      (2, 0, 0),
      none-style(),
    ),
    (
      (1, 0, 0),
      request(),
    ),
    (
      (2, 4, 4),
      none-style(),
    ),
  ),
)

#let imex3b = custom_im_blocks(
  (
    (
      (4, 0, 4, 3),
      none-style(),
    ),
  ),
)

#let imex3c = custom_im_blocks(
  (
    (
      (0, 0, 1, 0),
      request(),
    ),
    (
      (4, 0, 3, 1),
      none-style(),
    ),
  ),
)

#let imex3d = canvas(length: 0.9cm, draw_blocks((
  (
    (0, 0, 4, 0),
    none-style(stroke_ext: (dash: "dashed")),
  ),
  (
    (4, 2, 0, 2),
    none-style(),
  ),
)))





#subpar.grid(
  figure(imex3a, caption: [The state $F(c)$]), <imex3a>, figure(imex3b, caption: [The state $d$]), <imex3b>,
  figure(imex3c, caption: [The state $F(d)$]), <imex3c>, figure(imex3d, caption: [The state $L(F(d))$]), <imex3d>,
  columns: (1fr, 1fr, 1fr, 1fr),
  caption: [Beginning of a play induced by $L,F$],
  label: <ex3>,
)

#example()[
  Let's consider the state $c$ represented in @imex3a, without the request. The strategy $F$ chooses the first stack because it is the highest, then it requests the lowest container it can, i.e. the third one because, if $H = 5$, there is only two positions where player $1$ can relocate the container.
]

These two strategies being intuitive and consistent, it is possible to obtain a formula giving the value induces by it, which does not need any computation of the steps of the game.

#theorem(title: "Value induced by L & F")[
  aaaaaaaa
]

The main theorem we want to prove is the optimality of these strategies, given the above context i.e. both players can use memoryless adaptative and deterministic strategies. We will first prove that these strategies are optimal one against the other, in @proof_opposing. This will be enough to prove the determinacy of the game and the optimality of $L,F$.

#theorem(title: "opposing optimality")[for every $s in Q_1 union Q_2$
  $
    max_(pi in Pi) val_(L,pi) (s) = val_(L,F)(s) = min_(sigma in Sigma) val_(sigma,F) (s)
  $
]<opposing_opt>

#corollary(title: "value of the game")[
  Given $s in Q_1 union Q_2$, $G_s$ is determined and its value is
  $
    val(s) := val_(L,F) (s) = min_(sigma in Sigma) max_(pi in Pi) val_(sigma,pi)(s) = max_(pi in Pi) min_(sigma in Sigma) val_(sigma,pi)(s)
  $
] <determined>

#proof()[
  Let $pi in Pi$, by @opposing_opt, $min_(sigma in Sigma) val_(sigma,pi)(s) <= val_(L,pi) (s)$. So $ max_(pi in Pi) min_(sigma in Sigma) val_(sigma,pi)(s) <= max_(pi in Pi) val_(L,pi)(s) = val_(L,F) (s) $
  We also have $ max_(pi in Pi) min_(sigma in Sigma) val_(sigma,pi)(s) >= min_(sigma in Sigma) val_(sigma,F)(s) = val_(L,F) (s) $
  Now let $sigma in Sigma$, still by @opposing_opt $max_(pi in Pi) val_(sigma,pi)(s) >= val_(sigma,F)(s)$. So $ min_(sigma in Sigma) max_(pi in Pi) val_(sigma,pi)(s) >= min_(sigma in Sigma) val_(sigma,F)(s) = val_(L,F) (s) $
  We also have $ min_(sigma in Sigma) max_(pi in Pi) val_(sigma,pi)(s) >= max_(pi in Pi) val_(L,pi)(s) = val_(L,F) (s) $
]








= Proof of @opposing_opt <proof_opposing>

We start by giving some definitions to help us handling the strategies $L,F$ and manipulate similarity between configurations.


#definition(title: "order of the bay")[
  We define a total order $prec$ on the coordinates of the bay given by $(i,j) prec.eq (i',j')$ if and only if $j < j' or (j = j' and i < i')$. Reading the coordinates left to right, bottom to up gives the coordinates of the bay in increasing order. We also consider its reflexive closure $prec.eq$.
]

By definition of $L$, it relocates its containers to the smallest free coordinates for the order $prec$, yet some details may be formally annoying, as the fact it cannot relocate on the stack the containers are coming from. So we also give some more notations about it

#definition(title: "free space")[
  Given $1 <= i <= W$ and $s in Q_2$, we call $free_i (s)= {(w,h) in bay \\ Q_2 | w eq.not i}$. A quick analysis on the size of $free_i (s)$ gives us that if the opponent tries to ask for the deepest container possible on stack $i$, the height of the stack he will request does not depend on $i$.
] <free_space>

#proof()[
  if player $2$ tries to request on stack $i$, he can ask for $(i,j)$ if and only if $torel(s^(i,j)) <= free_i (s)$ which is equivalent to $(W - 1) dot H >= |s| - j$ which does not depend on $i$.
]

#definition(title: "down relocation")[
  Let $s,t in Q_2$, we say that $s$ relocates downward to $t$ if there exists $b in Q_2$ such that $s = b union {(i,j)}, t = b union {(i',j')}$ and $(i,j) succ (i',j')$, which we denote by $s downlr("i", "i'") t$. As well as for relocation, it induces a definition for its transitive closure, and more generic operator as $down()$ or $downr("i'")$.
]

#definition(title: "L but formal")[
  Formally, let $s^(i,j) in Q_1$, we call $free_i^(<= k)$ the $k$ smallest element of $free_i (s)$ for the order $prec$ and $free_i^k (s)$ the $k$-th element of it. Then $L(s^(i,j)) = rem^(torel(s^(i,j)) + 1) (s) union free_i^(<= torel(s^(i,j))) (s)$
] <Lformal>

#definition(title: "configuration permutation")[
  Let $s,t in Q_2$, we say that $t$ is a permutation of $s$, in short $s equiv t$, if and only if there exists a permutation of the stacks $p in S_W$ such that $t = {(p(i),j) | (i,j) in s}$, if $p$ is known we denote it by $s equiv_p t$. Note that an equivalent definition is that the vector of height of $s$, i.e. $(h_i (s))_(1 <= i <= W)$ is a permutation of the one of $t$. A last one is that the multiset of heights of $s$ and $t$ are equal.
]

#proposition()[
  for any $s,t in Q_2$, such that $s equiv_p t$ and $1 <= i <= W$, we have $val_(L,F) (s^(i,r)) = val_(L,F) (t^(p(i),r))$
]<permutation_with_request>

#proof()[
  By induction on the size of the states $|s| = |t|$. Note that if $|s| = emptyset$, then $t = s$ and the result is trivial.

  Let us suppose the property true for any set of size at most $N > 0$, let $s,t in Q_2$ of size $N+1$ and $i,p,r$ verifying the hypothesis of the proposition. We get that $h_i (s) = h_(p(i)) (t)$ hence the number of relocated container is the same in both cases, so we don't take this cost into account, let $k = torel(s^(i,r))$ be this value. We have $L(s^(i,r)) = rem_i^k (s) union free_i^(<=k) (s)$ and $L(t^(p(i),r)) = rem_(p(i))^k (t) union free_(p(i))^(<=k) (t)$.

  We know that $s equiv_p t$, and $h_i (s) = h_(p(i)) (t)$, so $rem_i^k (s) equiv_p rem_(p(i))^k (t)$. Now notice that $free_i (s) equiv free_(p(i)) (t)$, they are as well a permutation of each other. Hence every elements of $free_i^(<=k) (s)$ can be associated to a unique element of $free_(p(i))^(<=k) (t)$ of same height. For every $(a,h) in free_i^(<=k) (s)$, if it is associated to $(b,h)$, then we permute $a,b$ in $p$. Adding them one by one to $rem_i^k (s)$ and $rem_(p(i))^k (t)$, we obtain that $L(s^(i,r)) equiv L(t^(p(i),r))$ and we can conclude thanks to the induction hypothesis.
]

#corollary()[
  For any $s,t in Q_2$ such that $s equiv t$, $val_(L,F) (s) = val_(L,F) (t)$
]<permutation_value>

#proof()[
  It directly follows from @permutation_with_request, we just have to choose $p$ such that $i$ and $p(i)$ are the stacks requested by $F$, i.e. the rightmost highest stacks.
]

#corollary()[
  For any $s,t in Q_2$ such that $s equiv_p t$ where $p$ is the tranposition $i,j$, $val_(L,F) (s^(i,r)) = val_(L,F) (t^(j,r))$
]<swap_value>

#corollary()[
  For any $s in Q_2$ such that $s$ and $1 <= i_1,i_2 <= W$ such that $h_i_1 (s) = h_i_2 (s)$, we have $val_(L,F) (s^(i_1,j)) = val_(L,F) (s^(i_2,j))$
]<swap_value_same_height>


















== First equation

We first tackle the equality $val_(L,F)(s) = min_(sigma in Sigma) val_(sigma,F) (s)$. So we fix the opponent as $F$ and show that $L$ is optimal. Let us do an induction on the number of containers, hence we can suppose this proposition to be true for any $s'$ of size at most $N$, let us consider some $s_0 in Q_1 union Q_2$ of size $N+1$. If $s_0 in Q_2$ then the first move is done by $F$, so we can suppose without loss of generality that $s_0 = t_0^(i,j) in Q_1$, hence we have
$
  forall sigma in Sigma, val_(sigma,F)(s_0)
  = torel(s_0) + val_(sigma,F)(sigma(s_0))
$
Since $torel(s_0)$ is independant from the decision of player $1$, his objective is to minimise $val_(sigma,F)(sigma(s_0))$. Let us consider $sigma in Sigma$ such that $sigma eq.not L$ and show that $val_(sigma,F)(sigma(s_0)) >= val_(L,F)(L(s_0))$. By induction hypothesis, and because $|sigma(s_0)| = N$ we have $val_(sigma,F)(sigma(s_0)) = val_(L,F)(sigma(s_0))$ so we only need to show that
$
  val_(L,F)(sigma(s_0)) >= val_(L,F)(L(s_0))
$
The core of the proof is to notice that $L(s_0)$ can be obtained from
$sigma(s_0)$ by a finite number of down relocations.


#proposition()[
  For any state $s in Q_1$ and strategy $sigma in Sigma$, we have $sigma(s) down()^* L(s)$
] <p_L_down>

#proof()[
  Let $i,j$ be such that $s = t^(i,j)$ and let $k = torel(s)$. We know that $L(s) = rem_i^(k + 1) (t) union R$ where $R = free_i^(<=k) (t)$. Yet $sigma(s) = rem_i^(k + 1) (t) union S$ where $S$ is an arbitrary subset of $free_i (t)$ of size $k$. For sake of brevity, we won't prove this claim formally, but it is a direct consequence from the definition of $-->$ and the commutativity of the functions $rem_i$ and $add_(i')$ for $i' eq.not i$.

  By definition of $R$, we can associate to each $(p,q) in S$ a unique element $(u,v) in R$ such that $(u,v) prec (p,q)$. Since $|R| = |S|$, a trivial induction on the size of $|R|$ gives us that $sigma(s) down()^* L(s)$. In this induction, one should be aware that we need to remove the common elements of $R$ and $S$ because the downward relocation relation is not reflexive, and if $R = S$, it is not a problem since the reflexive transitive closure $down()^*$ is reflexive.
]

Now it only remains to show that $L$ is better against $F$ on "lower"
configurations of containers. First we show that if we look at the request $F$ makes on two similar states $s down() t$, then we can suppose without loss of generality that the request is on the same stack by swapping some stacks. Moreover, this preserves the propertiy that the new states are equal up to a down relocation. It will be useful later in the proof.

#proposition()[
  For any $s,t in Q_2$ such that $s downlr("u", "p") t$, more precisely $s = b union {(u,v)}, t = b union {(p,q)}$. One of the following is true:
  - $s equiv t$
  - There exists $m eq.not p$ and $n$ such that $val_(L,F) (t) = val_(L,F) (t^(m,n))$ and $val_(L,F) (s) = val_(L,F) (s^(m,n))$.
] <same_stack_down>

#proof()[
  We seek for the second condition, first notice that since the height of the container requested by $F$ only depends on the current number of containers, if such $m,n$ exist then we must have $n = max(1, |s| - (W-1)dot H)$.

  Then let us do a case analysis, first let $(x,y)$ be the coordinate of the bigger element of $b$ for the order $prec$. In the representation of the cases in @same_stack_im, we indicate by a dot the requests made by $F$ on $s$ and on $t$. The plain containers are the one from $b$ and the dashed one are $(u,v),(p,q)$:
  - Either $(u,v) prec (x,y)$ this case is represented in @ssia. By definition of $prec$, $x$ is the rightmost highest stack in $s$ and $t$ so $m := x$ is valid. See @ssia.
  - Either $(p,q) prec (x,y) prec.eq (u,v)$, in which case $u$ is the highest stack in $s$, and $x$ is the highest stack in $t$. Let us notice that $v in {y,y+1}$.
    + if $v = y$ we have $h_x (s) = h_u (s)$ so, by @swap_value_same_height, $val_(L,F) (s) = val_(L,F) (s^(u,n)) = val_(L,F) (s^(x,n))$ so $m = x$ is valid. See @ssib.
    + Else $v = y+1$, in which case $h_u (t) = y = h_x (t)$, similarly we get that $m = u$ is valid. See @ssic.
  - Either $(x,y) prec.eq (p,q) prec (u,v)$, so $F$ requests stack $u$ for $s$ and stack $p$ for $t$. We can first notice that $y <= q <= v <= y+1$ :
    + if $q = v$ then $s equiv t$ by a permutation of stacks $u,p$. See @ssid.
    + Else $q = j, v = j+1$, so $h_p (t) = h_u (t)$, therefore we can choose $m = u$ again thank to @swap_value_same_height. See @ssie.

  We can also check that in every cases either $s' = t'$ or $s' down() t'$. Moreover, we have $m in {u,x}$ and both $u$ and $x$ are distinct from $p$, hence we have $m eq.not p$.
]

#let ssia = canvas(length: 0.9cm, {
  import draw: *
  draw_blocks((
    (
      (0, 0, 0, 0, 1, 0),
      request(),
    ),
    (
      (1, 2, 3, 4, 3, 3),
      none-style(),
    ),
    (
      (1, 1, 0, 0, 0, 0),
      none-style(stroke_ext: (dash: "dashed")),
    ),
  ))
  content((4.3, 0.3), [$s$])
  content((4.7, 0.3), [$t$])
  content((0.5, 1.5), [$p,q$])
  content((1.5, 2.5), [$u,v$])
  content((4.5, 3.5), [$x,y$])
})

#let ssib = canvas(length: 0.9cm, {
  import draw: *
  draw_blocks((
    (
      (0, 0, 0, 0, 1, 1),
      request(),
    ),
    (
      (1, 2, 3, 4, 3, 2),
      none-style(),
    ),
    (
      (1, 0, 0, 0, 0, 1),
      none-style(stroke_ext: (dash: "dashed")),
    ),
  ))
  content((5.3, 0.3), [$s$])
  content((4.3, 0.3), [$t$])
  content((0.5, 1.5), [$p,q$])
  content((5.5, 3.5), [$u,v$])
  content((4.5, 3.5), [$x,y$])
})

#let ssic = canvas(length: 0.9cm, {
  import draw: *
  draw_blocks((
    (
      (0, 0, 0, 1, 1, 0),
      request(),
    ),
    (
      (1, 2, 3, 3, 3, 3),
      none-style(),
    ),
    (
      (1, 0, 0, 1, 0, 0),
      none-style(stroke_ext: (dash: "dashed")),
    ),
  ))
  content((4.3, 0.3), [$t$])
  content((3.3, 0.3), [$s$])
  content((0.5, 1.5), [$p,q$])
  content((3.5, 4.5), [$u,v$])
  content((4.5, 3.5), [$x,y$])
})

#let ssid = canvas(length: 0.9cm, {
  import draw: *
  draw_blocks((
    (
      (0, 0, 0, 1, 1, 0),
      request(),
    ),
    (
      (1, 2, 3, 3, 3, 3),
      none-style(),
    ),
    (
      (0, 0, 0, 1, 1, 0),
      none-style(stroke_ext: (dash: "dashed")),
    ),
  ))
  content((4.3, 0.3), [$s$])
  content((3.3, 0.3), [$t$])
  content((3.5, 4.5), [$p,q$])
  content((4.5, 4.5), [$u,v$])
  content((4.5, 3.5), [$x,y$])
})

#let ssie = canvas(length: 0.9cm, {
  import draw: *
  draw_blocks((
    (
      (0, 0, 0, 1, 0, 1),
      request(),
    ),
    (
      (1, 2, 3, 3, 4, 2),
      none-style(),
    ),
    (
      (0, 0, 0, 1, 0, 1),
      none-style(stroke_ext: (dash: "dashed")),
    ),
  ))
  content((3.3, 0.3), [$s$])
  content((5.3, 0.3), [$t$])
  content((3.5, 4.5), [$u,v$])
  content((5.5, 3.5), [$p,q$])
  content((4.5, 3.5), [$x,y$])
})

#subpar.grid(
  figure(ssia, caption: [$(u,v) prec (x,y)$]),
  <ssia>,
  figure(ssib, caption: [$(p,q) prec (u,v) prec (x,y)$ and $v = y$]),
  <ssib>,
  figure(ssic, caption: [$(p,q) prec (u,v) prec (x,y)$ and $v = y + 1$]),
  <ssic>,
  figure(ssid, caption: [$(x,y) prec (p,q)$ and $v = q$]),
  <ssid>,
  grid.cell(colspan: 2, [#figure(ssie, caption: [$(x,y) prec (p,q)$ and $v = q + 1$]) <ssie>]),
  columns: (1fr, 1fr),
  caption: [Representation of every cases from the proof of @same_stack_down],
  label: <same_stack_im>,
)


#proposition()[
  for any $s,t in Q_2$, such that $s down() t$ with $s = b union {(u,v)}$ and $t = b union {(p,q)}$. Let $(i,j)$ be a request on $b$, we have the following:
  + If $i eq.not p$, $val_(L,F)(t^(i,j)) + 1 >= val_(L,F)(s^(i,j)) >= val_(L,F)(t^(i,j))$
] <bound_down_general>

#proof()[
  Let us do an induction on $|s|$ so that we only have to consider one move. The base case where $|s| = 1$ is trivial because both configurations $s$ and $t$ have a cost of $1$ whatever strategies are played.

  Let us consider some $s,t in Q_2$ satisfying the hypothesis of the proposition with $2 <= |s| = n <= N$. and let $b in Q_2, (u,v),(p,q) in bay$ such that $s = b union {(u,v)}, t = b union {(p,q)}$, by the hypothesis we also have $(p,q) prec (u,v)$.

  We have $2$ cases to consider, $i = u, i eq.not u,p$:

  + If the request is on $(i,j)$ with $i eq.not u,p$, we have $(u,v),(p,q) in free_i (b)$, let $r_s,r_t$ be the rank of $(u,v)$ and $(p,q)$ in $free_i (b)$ for the order $prec$, we have $r_s > r_t$. The number of relocated containers is the same for both $s$ and $t$, because $i eq.not u,p$, it is $k = torel(t^(i,j)) = torel(s^(i,j))$. We have $L(s^(i,j)) = rem_i^(k+1) (b) union free_i^(<=k) (s) union {(u,v)}$ and $L(t^(i,j)) = rem_i^(k+1) (b) union free_i^(<=k) (t) union {(p,q)}$. By noticing that $free_i (s) = free_i (b) \\ {(u,v)}$ and $free_i (t) = free_i (b) \\ {(p,q)}$, we get that :

    - If $k < r_t < r_s$ then $free_i^(<=k) (s) = free_i^(<=k) (t)$, and $L(s^(i,j)) down() L(t^(i,j))$.

    - If $r_t <= k < r_s - 1$ then we have $free_i^(<=k) (s) = free_i^(<=k) (t) \\ {free_i^(k+1) (b)} union {(p,q)}$, hence $L(s^(i,j)) union {free_i^(k+1) (b)} = L(t^(i,j)) union {(u,v)} = L(t^(i,j)) union {free_i^(r_s) (b)}$, since $k + 1 < r_s$, we have $L(s^(i,j)) down() L(t^(i,j))$

    - If $k >= r_s - 1$ then $free_i^(<=k) (s) union {(u,v)} = free_i^(<=k) (t) union {(p,q)}$ and we get $L(s^(i,j)) = L(t^(i,j))$, hence $val_(L,F) (s^(i,j)) = val_(L,F) (s^(i,j))$, which directly gives the wanted result.

    In the two first subcases, we have $L(s^(i,j)) down() L(t^(i,j))$, we use @same_stack_down, which says that either $L(s^(i,j)) equiv L(t^(i,j))$ and we conclude that the proposition is true by @permutation_value. Or there exists $m,n$ such that $val_(L,F) (s^(i,j)) = val_(L,F) (L(s^(i,j))^(m,n))$ and $val_(L,F) (t^(i,j)) = val_(L,F) (L(t^(i,j))^(m,n))$, yet we know that $L(s^(i,j)) downr("w") L(t^(i,j))$ and that $m eq.not w$ so we can use the induction hypothesis $(1)$, which says that $val_(L,F) (L(t^(i,j))) + 1 >= val_(L,F) (L(s^(i,j))) >= val_(L,F) (L(t^(i,j)))$, finally, we conclude by adding $torel(s^(i,j))$ on each member of the inequality.

  + If the request is on $(u,j)$ then we have $(p,q) in free_u (b)$, let $r_t$ be the rank of $(p,q)$ in $free_u (b)$ for the order $prec$. The number of relocated containers is not the same anymore for $s$ and $t$, noting $k = torel(t^(u,j))$, we indeed have $torel(s^(u,j)) = k+1$. We have $L(s^(u,j)) = rem_u^(k+2) (s) union free_u^(<=k+1) (s)$, yet we have $rem_u(s) = b$, so $L(s^(u,j)) = rem_u^(k+1) (b) union free_u^(<=k+1) (s)$ and $L(t^(u,j)) = rem^(k+1) (b) union free_u^(<=k) (t) union {(p,q)}$. By noticing that $free_u (s) = free_u (b)$ and $free_u (t) = free_u (b) \\ {(p,q)}$, we get that :

    - If $k + 1 < r_t$ then we have $free_u^(<=k+1) (s) = free_u^(<=k) (t) union {free_u^(k+1) (b)}$, so $L(s^(u,j)) union {free_u^(r_t) (b)} = L(t^(u,j)) union {free_u^(k+1) (b)}$, since $k+1 < r_t$ we get $L(t^(u,j)) down() L(s^(u,j))$ (Note that the direction is not the same!). As before, we use @same_stack_down to enable the induction hypothesis $(1)$, hence we get that $val_(L,F)(L(s^(u,j))) + 1 >= val_(L,F)(L(t^(u,j))) >= val_(L,F)(L(s^(u,j)))$, by adding $k$ in the inequality we get $val_(L,F)(s) >= val_(L,F)(t) >= val_(L,F)(s) - 1$.

    - If $r_t <= k + 1$ then $free_u^(<=k+1) (s) = free_u^(<=k) (t) union {free_u^(r_t) (b)}$, hence $L(s^(u,j)) = L(t^(u,j))$ which gives $val_(L,F) (s^(u,j)) = val_(L,F) (t^(u,j))$. By adding $k$ on both sides we obtain $val_(L,F) (s) - 1 = val_(L,F) (t)$ which finishes the proof.
]

#let bdga = canvas(length: 0.9cm, {
  import draw: *
  draw_blocks((
    (
      (0, 0, 0, 0, 0, 1),
      request(),
    ),
    (
      (0, 0, 1, 2, 3, 0),
      none-style(),
    ),
    (
      (0, 0, 1, 1, 0, 0),
      none-style(stroke_ext: (dash: "dashed")),
    ),
    (
      (0, 0, 0, 0, 0, 3),
      zone(fill: gray),
    ),
  ))
  content((5.3, 0.3), [$i$])
  content((5.5, 2.5), [$k$])
  content((2.5, 1.5), [$p,q$])
  content((3.5, 2.5), [$u,v$])
})

#let bdgb = canvas(length: 0.9cm, {
  import draw: *
  draw_blocks((
    (
      (0, 0, 1, 2, 3, 0),
      none-style(),
    ),
    (
      (0, 0, 1, 1, 0, 0),
      none-style(stroke_ext: (dash: "dashed")),
    ),
    (
      (2, 1, 0, 0, 0, 0),
      zone(fill: gray),
    ),
  ))
  content((0.5, 0.5), [$k$])
  content((2.5, 1.5), [$p,q$])
  content((3.5, 2.5), [$u,v$])
})

#let bdgc = canvas(length: 0.9cm, {
  import draw: *
  draw_blocks((
    (
      (0, 0, 0, 0, 0, 1),
      request(),
    ),
    (
      (0, 0, 1, 2, 3, 0),
      none-style(),
    ),
    (
      (0, 1, 0, 1, 0, 0),
      none-style(stroke_ext: (dash: "dashed")),
    ),
    (
      (0, 0, 0, 0, 0, 3),
      zone(fill: gray),
    ),
  ))
  content((5.5, 2.5), [$k$])
  content((1.5, 0.5), [$p,q$])
  content((3.5, 2.5), [$u,v$])
  content((5.3, 0.3), [$i$])
})

#let bdgd = canvas(length: 0.9cm, {
  import draw: *
  draw_blocks((
    (
      (0, 0, 1, 2, 3, 0),
      none-style(),
    ),
    (
      (2, 1, 0, 0, 0, 0),
      zone(fill: gray),
    ),
    (
      (0, 1, 0, 1, 0, 0),
      none-style(stroke_ext: (dash: "dashed")),
    ),
  ))
  content((0.5, 0.5), [$k$])
  content((1.5, 1.5), [$x,y$])
  content((3.5, 2.5), [$u,v$])
})

#let bdge = canvas(length: 0.9cm, {
  import draw: *
  draw_blocks((
    (
      (0, 0, 0, 0, 0, 1),
      request(),
    ),
    (
      (0, 0, 1, 2, 3, 0),
      none-style(),
    ),
    (
      (1, 1, 0, 0, 0, 0),
      none-style(stroke_ext: (dash: "dashed")),
    ),
    (
      (0, 0, 0, 0, 0, 3),
      zone(fill: gray),
    ),
  ))
  content((5.5, 2.5), [$k$])
  content((1.5, 0.5), [$p,q$])
  content((0.5, 0.5), [$u,v$])
  content((5.3, 0.3), [$i$])
})

#let bdgf = canvas(length: 0.9cm, {
  import draw: *
  draw_blocks((
    (
      (0, 0, 1, 2, 3, 0),
      none-style(),
    ),
    (
      (2, 2, 0, 0, 0, 0),
      zone(fill: gray),
    ),
  ))
  content((1, 1), [$k + 1$])
})

#let bdgg = canvas(length: 0.9cm, {
  import draw: *
  draw_blocks((
    (
      (0, 0, 0, 0, 0, 1),
      request(),
    ),
    (
      (0, 0, 1, 2, 3, 0),
      none-style(),
    ),
    (
      (0, 0, 0, 0, 0, 2),
      zone(fill: gray),
    ),
    (
      (0, 0, 1, 0, 0, 1),
      none-style(stroke_ext: (dash: "dashed")),
    ),
  ))
  content((5.5, 2), [$k$])
  content((2.5, 1.5), [$p,q$])
  content((5.5, 3.5), [$u,v$])
  content((5.3, 0.3), [$i$])
})
#let bdgh = canvas(length: 0.9cm, {
  import draw: *
  draw_blocks((
    (
      (0, 0, 1, 2, 3, 0),
      none-style(),
    ),
    (
      (1, 1, 0, 0, 0, 0),
      zone(fill: gray),
    ),
    (
      (1, 0, 1, 0, 0, 0),
      none-style(stroke_ext: (dash: "dashed")),
    ),
  ))
  content((1, 0.5), [$k$])
  content((2.5, 1.5), [$p,q$])
  content((0.5, 1.5), [$x,y$])
})
#let bdgi = canvas(length: 0.9cm, {
  import draw: *
  draw_blocks((
    (
      (0, 0, 0, 0, 0, 1),
      request(),
    ),
    (
      (0, 0, 1, 2, 3, 0),
      none-style(),
    ),
    (
      (0, 0, 0, 0, 0, 2),
      zone(fill: gray),
    ),
    (
      (0, 1, 0, 0, 0, 1),
      none-style(stroke_ext: (dash: "dashed")),
    ),
  ))
  content((5.5, 2), [$k$])
  content((1.5, 0.5), [$p,q$])
  content((5.5, 3.5), [$u,v$])
  content((5.3, 0.3), [$i$])
})
#let bdgj = canvas(length: 0.9cm, {
  import draw: *
  draw_blocks((
    (
      (0, 0, 1, 2, 3, 0),
      none-style(),
    ),
    (
      (2, 1, 0, 0, 0, 0),
      zone(fill: gray),
    ),
  ))
  content((1, 0.5), [$k+1$])
})

#subpar.grid(
  figure(bdga, caption: [$(u,v) prec (x,y)$]), <bdga>,
  figure(bdgb, caption: [$(p,q) prec (u,v) prec (x,y)$ and $v = y$]), <bdgb>,
  figure(bdgc, caption: [$(p,q) prec (u,v) prec (x,y)$ and $v = y + 1$]), <bdgc>,
  figure(bdgd, caption: [$(x,y) prec (p,q)$ and $v = q$]), <bdgd>,
  figure(bdge, caption: [$(x,y) prec (p,q)$ and $v = q$]), <bdge>,
  figure(bdgf, caption: [$(x,y) prec (p,q)$ and $v = q$]), <bdgf>,
  figure(bdgg, caption: [$(x,y) prec (p,q)$ and $v = q$]), <bdgg>,
  figure(bdgh, caption: [$(x,y) prec (p,q)$ and $v = q$]), <bdgh>,
  figure(bdgi, caption: [$(x,y) prec (p,q)$ and $v = q$]), <bdgi>,
  figure(bdgj, caption: [$(x,y) prec (p,q)$ and $v = q$]), <bdgj>,

  columns: (1fr, 1fr),
  caption: [Representation of every cases from the proof of @bound_down_general],
  label: <bound_down_im>,
)

#corollary()[
  for any $s,t in Q_2$, such that $s down() t$ we have $val_(L,F)(t) + 1 >= val_(L,F)(s) >= val_(L,F)(t)$
] <bound_down>

#proof()[
  We have by @same_stack_down some equivalent states $s',t'$ and $m,n$ such that $val_(L,F) (s) = val_(L,F) (s'^(m,n))$ and $val_(L,F) (t) = val_(L,F) (t'^(m,n))$. We also have $s' downr("p") t'$ and $m eq.not p$, so we can use @bound_down_general and conclude.
]

By noticing that if $s rel() t$ then either $s down() t$ or $t down() s$, we get the following corollary about $->_R$.

#corollary()[
  for any $s,t in Q_2$, such that $s rel() t$ we have
  $|val_(L,F)(s) - val_(L,F)(t)| <= 1$
] <R_bound>

An immediate induction using @bound_down proves this second corollary.

#corollary()[
  for any $s,t in Q_2$ such that $s down()^* t$, we have $val_(L,F)(s) >= val_(L,F)(t)$.
] <L_better_on_down>

Finally, applying @p_L_down on $s_0$ and $sigma$, and using @L_better_on_down on $sigma(s_0)$ and $L(s_0)$, we get that $val_(L,F)(sigma(s_0)) >= val_(L,F)(L(s_0))$. According to what is above, this proves that $ val_(L,F)(s_0) = min_(sigma in Sigma) val_(sigma,F) (s_0) $

This finishes the induction and therefore the proof of this first part of @opposing_opt.





























== second part

It remains to prove the second equality, i.e. $val_(L,F)(s_0) = max_(pi in Pi) val_(L,pi) (s_0)$. Now we fix player $1$ strategy to $L$ and again do an induction on $|s_0|$. The base case is trivial as well, for the induction case, if $s_0 in Q_1$, then $L$ is played first, so we can suppose without loss of generality that the initial state is $s_0 in Q_2$.

First we want to show it is optimal for player $2$ to choose a container as low as possible. Let us fix some $pi in Pi$ that doesn't choose the lowest box, we consider the induced first move leading to the state $s_0^(i,j)$ and then to $L(s_0^(i,j))$. Let $k = torel(s_0^(i,j))$, the induction hypothesis tells us that $ val_(L,F)(L(s_0^(i,j))) = max_(pi' in Pi) val_(L,pi') (L(s_0^(i,j))) $ Hence, if we consider $pi_F in Pi$ the strategy playing the same move as $pi$ and then acting like $F$, we have $ val_(L,pi_F) (s_0) & = k + val_(L,pi_F)(L(s_0^(i,j))) \
                   & = k + val_(L,F)(L(s_0^(i,j))) \
                   & >= k + val_(L,pi)(L(s_0^(i,j))) \
                   & = val_(L,pi) (s_0) $
Now we look at the strategy $pi'_F in Pi$, similar to $pi_F$ but selects the box $(i,j-1)$ instead of $(i,j)$. We get $  val_(L,pi_F) (s_0) & = k + val_(L,F) (L(s_0^(i,j))) \
val_(L,pi'_F) (s_0) & = k + 1 + val_(L,F) (L(s_0^(i,j-1))) $

Similarly as before, we can notice that these two states : $L(s_0^(i,j-1))$ and $L(s_0^(i,j))$
are very similar. Indeed, we precisely have

#proposition()[
  for any $s^(i,j)$ in $Q_1$, if $j > 1$ and if $s^(i,j-1) in Q_1$ then
  $L(s^(i,j-1)) relr("i") L(s^(i,j))$
] <ask_bottom>

#proof()[
  Keeping the notation $k = torel(s^(i,j))$ we have $L(s^(i,j)) = rem_i^(k+1) (s) union free_i^(<=k) (s)$, and $L(s^(i,j-1)) = rem_i^(k+2) (s) union free_i^(<=(k+1)) (s)$. Hence by denoting $(u,v)$ the $(k+1)$th element of $free_i (s)$ we have $L(s^(i,j)) union {(u,v)} = L(s^(i,j-1)) union {(i,j-1)}$.
]

Using @ask_bottom and @R_bound, we obtain the following inequality
$val_(L,F) (L(s_0^(i,j-1))) + 1 >= val_(L,F) (L(s_0^(i,j)))$ and
thus $val_(L,pi) (s_0) <= val_(L,pi_F) (s_0) <= val_(L,pi'_F) (s_0)$

Now we only consider strategies asking for deepest containers, i.e. $(pi_i)_(1 <= i <= W)$, each of them being a request at bottom on stack $i$ followed by strategy $F$. We already know that
$
  max_(pi in Pi) val_(L,pi) (s_0) = max_(1 <= i <= W) val_(L,pi_i) (s_0)
$

The aim is to show that the optimal strategy for player $2$ is $F = pi_i$ where $i$ is the rightmost highest stack.

#proposition()[
  For any $s in Q_2$ such that $|s| <= N+1$, for all $1 <= i,j <= W$ such
  that $s_i >= s_j$, $val_(L,pi_i)(s) >= val_(L,pi_j)(s)$
] <ask_biggest>

#proof()[
  Consider all the objects from the proposition, the player $2$ plays first and chooses in both cases the same height, as seen in @free_space, let $r$ be this height.
  We reach the states $s^(i,r)$ and $s^(j,r)$. We replace the second state $s^(j,r)$ by $t^(i,r)$ by swapping the stacks $i$ and $j$ thanks to @swap_value. let us call $Delta = h_i (s) - h_i (t)$, we have $s rellr("i", "j")^Delta t$.
  Let $s'$ be the state obtained after the $Delta$ first relocations in $s^(i,j)$, i.e. $s' = rem_i^Delta (s) union free_i^(<= Delta) (s)$. Notice that $L(s^(i,r)) = L(s'^(i,r))$ (intuitively $s'$ is just an intermediate state of the execution of $L$) and that $s' rel()^Delta t$, which is true because $t = rem_i^Delta (s) union R$ for some $R subset.eq free_i (s)$ of size $Delta$. Hence we have using @R_bound:
  $
    val_(L,F) (s^(i,r)) & = Delta + val_(L,F) (s'^(i,r)) \
                        & >= Delta + val_(L,F) (t^(i,r)) - Delta \
                        & = val_(L,F) (s^(j,r))
  $
]

Finally, @ask_biggest gives us the equality
$
  max_(pi in Pi) val_(L,pi) (s_0) = max_(1 <= i <= W) val_(L,pi_i) (s_0) = val_(L,F) (s_0)
$
and finishes the induction.




















= Non adaptative adversary <non-adaptative>

It is important to look back at what implies this result on our original problem, more precisely to look at the sets of allowed strategies. In @optimal_strat, player 2 is able to react to what player 1 is doing, because its strategy takes as input the position of the boxes. Hence we may come back to the context given by @ZEHENDNER201748, where the boxes have a retrieve order chosen by player $2$ at the beginning and unknown to player $1$, which exactly is the online framework. For sake of brevity, we won't formalise that new game and just give a rough idea of its components.

#definition(title: "permutation CRP game")[
  The permutation CRP game is very similar to a CRP game, here is a list of the changes :
  - The states $Q$, except the inital one, have the containers numbered. The ids of the containers represent the retrieve order, hence they must be distinct.
  - the player 2 can play only once, at the start of the game, by choosing the numbers (let's say a permutation of ${1,...,n}$) associated to each container.
  - the player 1 then plays alone. At every step, the container having the smallest id is requested. He has to take a decision based only on the heights of the stack, it is done by giving a projection from $rem : Q -> Q_1$ which removes the ids, then the player $1$ moves the boxes one by one without seeing the ids.
]


From the point of view of the player $1$, the game is exactly the same. He doesn't see ids and after each play he receives a request. For the player $2$, it is quite different because he cannot adapt anymore, after he plays, its moves are fixed for the whole duration of the game.

#definition(title: "strategies, play, value")[
  Let us call $overline(Sigma) = Sigma$ and $overline(Pi)$ the set of strategies for both players in the PCRP game. Given $overline(sigma) in overline(Sigma), overline(pi) in overline(Pi)$, an initial state $s in [|0,H|]^W$, a play is induced and its value is defined the same way as for CRP, we note it $overline(val)_(overline(sigma),overline(pi)) (s)$.
]

#remark(title: "player 1 strategies")[
  Notice that player $1$ strategies are the same in both games, since even in PCRP, he can't see the containers. So for a strategy $overline(sigma) in overline(Sigma)$, we will arbitrarily talk about $sigma$, the same strategy but considered in a CRP game.
]

This game exactly describes an online algorithm for the online CRP. We already proved that the heuristic $L$ was optimal for the previous game, the question is now to know wether it is still optimal when the opponent is restricted to permutation play. The following theorem gives more insight about this.

#theorem()[
  We have $ min_(overline(sigma) in overline(Sigma)) max_(overline(pi) in overline(Pi)) overline(val)_(overline(sigma),overline(pi)) (s) = val_(L,F)(s) >= max_(overline(pi) in overline(Pi)) min_(overline(sigma) in overline(Sigma)) overline(val)_(overline(sigma),overline(pi)) (s) $
  And the inequality is not always an equality. Hence PCRP is not determined in general.
] <PCRP_value>

#proof()[
  The core of the proof is to notice that for any $overline(sigma) in overline(Sigma)$, there exists $F_sigma in overline(Pi)$ such that $overline(val)_(overline(sigma),F_sigma) (s) = val_(sigma,F)(s)$. Let us fix $overline(sigma)$ and an initial state $s$, we will inductively build such a strategy $F_sigma$, which is an order on the containers.
  Simply choose the deepest box on the biggest stack of $s$ as container $1$. Then simulate one move of $overline(sigma)$. Next, consider the deepest container on the biggest stack, determine its initial position in $s$ and give it the id $2$ and so on.
  Since $overline(sigma)$ don't see the ids, modyfying the ids doesn't change its behavior, and by construction, this permutation acts (against $overline(sigma)$) as $F$.

  The second important argument is that $forall overline(sigma) in overline(Sigma), overline(pi) in overline(Pi)$, there exists $pi in Pi$ such that $val_(sigma,pi) (s) = overline(val)_(overline(sigma),overline(pi)) (s)$. Indeed let us fix $overline(sigma) = sigma$ and $overline(pi)$. We can simulate the induced game between these two and at each step, if the current state is $s_t$, we consider $rem(s_t)$ i.e. the same state without ids and choose $pi(rem(s_t))$ as the coordinate of the container requested by $overline(pi)$. By construction, $pi$ and $overline(pi)$ induces the same play against $sigma$.

  Hence $min_(overline(sigma) in overline(Sigma)) max_(overline(pi) in overline(Pi)) overline(val)_(overline(sigma),overline(pi)) (s) >= min_(overline(sigma) in overline(Sigma)) overline(val)_(overline(sigma),F_sigma) (s) = min_(overline(sigma) in overline(Sigma)) val_(sigma,F) (s) = val_(L,F) (s)$. Similarly $min_(overline(sigma) in overline(Sigma)) max_(overline(pi) in overline(Pi)) overline(val)_(overline(sigma),overline(pi)) (s) <= max_(overline(pi) in overline(Pi)) overline(val)_(L,overline(pi)) (s) <= max_(pi in Pi) val_(L,pi) (s) = val_(L,F) (s)$. The last inequality is given by the same argument : $max_(overline(pi) in overline(Pi)) min_(overline(sigma) in overline(Sigma)) overline(val)_(overline(sigma),overline(pi)) (s) <= max_(overline(pi) in overline(Pi)) overline(val)_(L,overline(pi)) (s) = val_(L,F) (s)$

  It remains to give an example where the last inequality is strict. Let us consider the initial state $s$ given in @counterexa. One can easily compute $val_(L,F) (s) = 5$, and then check that for every permutation of the numbered boxes, there is a way to complete the requests in at most 4 moves. This can be done by a case analysis given in @counterex.
  - If the container $1$ is above as in @counterexb, then we just retrieve it and the final cost is at most $3$ by computing $val_(L,F)$, which is an upper bound on the cost by what we showed above.
  - Now let's consider $1$ is below, if $2$ is above but not on $1$, as in @counterexc, we move the box $a$ on the third column, then we retrieve $2$ and get a maximal cost of $4$ by computing $val_(L,F)$
  - If $2$ is above $1$, as in @counterexd, we move it away and then retrieve it. We again get a maximal cost of $4$.
  - Now let us consider the case @counterexe, if $b < a$ or $c < d$, we just put the container $a$ above $b$, then we reach configuration @counterexf which has cost $0$ or $1$, at this point we already paid $3$, so we reach a maximal amount of $4$.
  - In the same example but with $a < b$ and $d < c$, we put the container $a$ on $c$ and reach after the second move the configuration @counterexg. At this point we paid $2$.
    + If $a < d$, then the remain cost is at most $2$ wether $c$ or $d$ is the next request.
    + If $a > d$, then $d$ is the next container to be retrieved since we supposed $a < b, d < c$. Hence we reach configuration @counterexh which has a cost of $0$ so the final cost is $4$.

  This gives an instance on which $max_(overline(pi) in overline(Pi)) min_(overline(sigma) in overline(Sigma)) overline(val)_(overline(sigma),overline(pi))(s) = 4 < 5 = val_(L,F)(s)$

  #let imempty6 = im_blocks((
    (
      (2, 2, 2),
      none-style(fill: gray),
    ),
  ))

  #let imcase1 = im_blocks((
    (
      (2, 2, 2),
      permutation(id_list: ($star$, 1, $star$, $star$, $star$, $star$), fill: gray, size: 16pt),
    ),
  ))

  #let imcase2 = im_blocks((
    (
      (2, 2, 2),
      permutation(id_list: (1, $a$, $star$, 2, $star$, $star$), fill: gray, size: 16pt),
    ),
  ))

  #let imcase3 = im_blocks((
    (
      (2, 2, 2),
      permutation(id_list: (1, 2, $star$, $star$, $star$, $star$), fill: gray, size: 16pt),
    ),
  ))

  #let imcase4 = im_blocks((
    (
      (2, 2, 2),
      permutation(id_list: (1, $a$, 2, $b$, $d$, $c$), fill: gray, size: 16pt),
    ),
  ))

  #let imcase5 = im_blocks((
    (
      (2, 0, 2),
      permutation(id_list: ($a$, $b$, $d$, $c$), fill: gray, size: 16pt),
    ),
  ))

  #let imcase6 = im_blocks((
    (
      (1, 0, 3),
      permutation(id_list: ($b$, $d$, $c$, $a$), fill: gray, size: 16pt),
    ),
  ))

  #let imcase7 = im_blocks((
    (
      (2, 1, 0),
      permutation(id_list: ($b$, $a$, $c$), fill: gray, size: 16pt),
    ),
  ))

  #subpar.grid(
    figure(imempty6, caption: "teste"), <counterexa>, figure(imcase1, caption: "testse"), <counterexb>,
    figure(imcase2, caption: "teste"), <counterexc>, figure(imcase3, caption: "testse"), <counterexd>,
    figure(imcase4, caption: "testse"), <counterexe>, figure(imcase5, caption: "testse"), <counterexf>,
    figure(imcase6, caption: "testse"), <counterexg>, figure(imcase7, caption: "testse"), <counterexh>,
    columns: (1fr, 1fr, 1fr, 1fr),
    caption: [full caption],
    label: <counterex>,
  )

]

Before concluding, we see that on the example from @counterex, the optimal offline algorithm pays at most $4$ while any online algorithm pays at least $5$ on some permutation. Hence we get the following lower bound on the competitive ratio of any deterministic online algorithm.

#corollary(title: "lower bound on the competitive ratio")[
  For any deterministic online algorithm for the online CRP, the competitive ratio of $A$ is at least $5 / 4$
]

The @PCRP_value confirms that even against weaker opponent, which is only able to choose a permutation of the containers, player $1$ can guarantee the same value as in the CRP game, with the same optimal strategy $L$.

#corollary(title: "optimality of L")[
  Given a configuration $s$ of the bay, for any deterministic algorithm $A$ and permutation $p in S_n$, we consider the induced number of relocation $cost_(A,p)(s)$ and the worst-case cost of $A$ being $cost_A (s) = max_(p in S_n) cost_(A,p)(s)$. Then, noting $cal(A)$ the set of deterministic algorithms for the online CRP, we have
  $
    min_(A in cal(A)) cost_A (s) = cost_L (s)
  $
  i.e. $L$ is worst-case optimal among deterministic algorithms
]










#bibliography("works.bib")
