#import "@preview/touying:0.6.1": *
#import themes.university: *
#import "@preview/cetz:0.4.0"
#import "@preview/fletcher:0.5.4" as fletcher: edge, node
#import "@preview/numbly:0.1.0": numbly
#import "@preview/theorion:0.3.2": *
#import "../utils/blocks.typ": *
#import cosmos.clouds: *
#show: show-theorion

#let OPT = math.op("OPT")
#let ALG = math.op("ALG")

// cetz and fletcher bindings for touying
#let cetz-canvas = touying-reducer.with(reduce: cetz.canvas, cover: cetz.draw.hide.with(bounds: true))
#let fletcher-diagram = touying-reducer.with(reduce: fletcher.diagram, cover: fletcher.hide)

#let conteneur_img = image("conteneur.jpg")

#show: university-theme.with(
  aspect-ratio: "16-9",
  // align: horizon,
  //config-common(handout: true),
  config-common(frozen-counters: (theorem-counter,)), // freeze theorem counter for animation
  config-info(
    title: [Online Container Relocation Problem],
    subtitle: [Internship supervised by Christoph Dürr],
    author: [Mathis Degryse],
    date: datetime.today(),
    institution: [LIP6],
  ),
)



#title-slide()

=

== Container Relocation Problem

#slide(repeat: 6, self => [
  #only("1")[
    ㅤ
  ]

  #only("2")[
    #grid(
      columns: (auto, auto),
      box(conteneur_img, height: 50%),
    )
  ]

  #only("3")[
    #grid(
      columns: (auto, auto),
      column-gutter: 4cm,
      box(conteneur_img, height: 50%),
      im_blocks(
        (
          (
            (3, 4, 2, 3, 1),
            none-style(),
          ),
        ),
        ratio: 12%,
      ),
    )
  ]

  #only("4-")[
    #grid(
      columns: (auto, auto),
      column-gutter: 4cm,
      box(conteneur_img, height: 50%),
      im_blocks(
        (
          (
            (3, 4, 2, 3, 1),
            permutation(id_list: (1, 7, 6, 5, 11, 4, 2, 13, 9, 10, 12, 8, 3), size: 14pt),
          ),
        ),
        ratio: 12%,
      ),
    )
  ]

  #uncover("4-")[
    - Containers are requested in order of priority
  ]

  #uncover("5-")[
    - Minimising the number of relocations is NP-complete
  ]

  #uncover("6-")[
    - Almost the entirety of litterature is about B&B and IP solving
  ]


])


== Goal of the Internship

#slide(repeat: 5, self => [
  #only("1-")[
    - Analyse the behaviour of the problem when the algorithm lacks information
  ]

  #only("2-")[
    - Start with an online model and add predictions throughout the Internship
  ]

  #grid(
    columns: (auto, auto, auto),
    uncover("3-")[
      #im_blocks(
        (
          (
            (1, 0, 0, 0, 0),
            request(size: 4pt),
          ),
          (
            (2, 4, 2, 3, 1),
            none-style(),
          ),
        ),
        ratio: 14%,
      )
    ],
    uncover("4-")[
      #im_blocks(
        (
          (
            (1, 0, 0, 0, 0),
            request(size: 4pt),
          ),
          (
            (1, 4, 2, 3, 1),
            none-style(),
          ),
          (
            (0, 0, 0, 0, 1),
            none-style(fill: gray),
          ),
        ),
        ratio: 14%,
      )
    ],
    uncover("5-")[
      #im_blocks(
        (
          (
            (1, 0, 0, 0, 0),
            request(size: 4pt),
          ),
          (
            (0, 4, 2, 3, 1),
            none-style(),
          ),
          (
            (0, 0, 1, 0, 1),
            none-style(fill: gray),
          ),
        ),
        ratio: 14%,
      )
    ],
  )


])


== Leveling Performances

#slide(repeat: 5, self => [
  #only("1-")[
    - Leveling relocates the container to the lowest available stack
  ]

  #only("2-")[
    #theorem(title: [Competitive ratio #cite(<ZEHENDNER201748>)])[
      The competitive ratio $c_L$ of Leveling verifies :
      $c_L <= 2 dot ceil(N/W) - 1$
    ]
  ]

  #grid(
    columns: (auto, auto, auto),
    row-gutter: 0.3cm,
    align: center + horizon,
    uncover("3-")[#im_blocks(
        (
          (
            (2, 3, 4, 2),
            permutation(id_list: (1, 4, 11, 10, 8, 7, 5, 2, 3, 6, 9), size: 15pt),
          ),
        ),
        ratio: 11%,
      )],
    uncover("4-")[#im_blocks(
        (
          (
            (1, 0, 0, 0),
            request(size: 4pt),
          ),
          (
            (1, 3, 4, 2),
            none-style(),
          ),
        ),
        ratio: 11%,
      )],
    uncover("5-")[$ALG$ is $c$-competitive if $ALG(s) <= c dot OPT(s)$],

    only("3-")[$OPT(s)$], only("4-")[$ALG(s)$],
  )

])

== Leveling Performances

#slide(repeat: 5, self => [
  #theorem(title: [Competitive ratio #cite(<ZEHENDNER201748>)])[
    The competitive ratio $c_L$ of Leveling verifies :
    $c_L <= 2 dot ceil(N/W) - 1$
  ]

  #only("2-")[
    - This bound is tight and is practically bad
  ]

  #grid(
    columns: (auto, auto),
    rows: (auto, auto),
    row-gutter: 1cm,
    grid.cell(rowspan: 2, uncover("3-")[#im_blocks(
        (((3, 5, 4), permutation(id_list: (6, 4, 2, 7, 5, 3, 1, 8, 12, 11, 10, 9), size: 15pt)),),
        ratio: 10%,
      )]),
    uncover("4-")[
      - This cost seems unavoidable
    ],
    uncover("5-")[
      - No existing proof of worst-case optimality
    ],
  )



])

== Leveling Performances

#slide(
  repeat: 5,
  self => [
    #only("1-2")[
      #theorem-box(title: "Theorem 2.")[
        Leveling is worst case optimal, i.e. $ forall s, max_(sigma in Sigma) c_(L,sigma)(s) = min_(ALG) max_(sigma in Sigma) c_(ALG,sigma) (s) $
      ]
    ]

    #only("2")[
      Still true if :
      - Containers arrive during the process
      - The algorithm is allowed to relocate non blocking containers
      - The stacks are replaced by a different structure satisfying some conditions
    ]

    #only("3")[
      #set align(center + horizon)
      #box(image("table.png"), height: 80%)
    ]

    #only("4-")[
      #theorem-box(title: [Conjecture 1. #cite(<AHHHH>)], outlined: false)[
        Leveling is optimal against an opponent choosing requests uniformly at random.
      ]
    ]

    #only("5-")[
      Unforrunately that's it.
    ]

  ],
)


== Current and Future Work

#slide(repeat: 10, self => [

  #only("1-3")[
    #theorem(title: [Competitive ratio #cite(<ZEHENDNER201748>)])[
      The competitive ratio $c_L$ of Leveling verifies :
      $c_L <= 2 dot ceil(N/W) - 1$
    ]
  ]

  #only("2-3")[
    - Lower bound equal to upper bound for the case of Leveling
  ]

  #only("3")[
    - Can we get a lower bound for any algorithm ?
  ]


  #set align(center + horizon)
  #only("4")[
    #grid(
      align: (center + horizon),
      columns: (auto, auto),
      im_blocks(
        (
          ((5, 3, 4, 4, 4, 4, 4), none-style()),
        ),
        ratio: 10%,
      ),
      im_blocks(
        (
          ((5, 3, 4, 4, 4, 4, 4), none-style()),
        ),
        ratio: 10%,
      ),
    )
  ]

  #only("5")[
    #grid(
      align: (center + bottom),
      columns: (auto, auto),
      im_blocks(
        (
          ((3, 3, 4, 4, 4, 4, 4), none-style()),
          ((1, 0, 0, 0, 0, 0, 0), permutation(id_list: (1,), size: 20pt)),
          ((1, 0, 0, 0, 0, 0, 0), none-style()),
        ),
        ratio: 10%,
      ),
      im_blocks(
        (
          ((3, 3, 4, 4, 4, 4, 4), none-style()),
          ((1, 0, 0, 0, 0, 0, 0), request(size: 6pt)),
          ((1, 0, 0, 0, 0, 0, 0), none-style()),
        ),
        ratio: 10%,
      ),
    )
  ]

  #only("6")[
    #grid(
      align: (center + bottom),
      columns: (auto, auto),
      im_blocks(
        (
          ((3, 3, 4, 4, 4, 4, 4), none-style()),
          ((1, 0, 0, 0, 0, 0, 0), permutation(id_list: (1,), size: 20pt)),
          ((1, 0, 0, 0, 0, 0, 0), none-style()),
        ),
        ratio: 10%,
      ),
      im_blocks(
        (
          ((3, 3, 4, 4, 4, 4, 4), none-style()),
          ((0, 1, 0, 0, 0, 0, 0), none-style(fill: gray)),
        ),
        ratio: 10%,
      ),
    )
  ]

  #only("7")[
    #grid(
      align: (center + bottom),
      columns: (auto, auto),
      im_blocks(
        (
          ((3, 2, 4, 4, 4, 4, 4), none-style()),
          ((1, 1, 0, 0, 0, 0, 0), permutation(id_list: (1, 2), size: 20pt)),
          ((1, 0, 0, 0, 0, 0, 0), none-style()),
        ),
        ratio: 10%,
      ),
      im_blocks(
        (
          ((3, 2, 4, 4, 4, 4, 4), none-style()),
          ((0, 1, 0, 0, 0, 0, 0), request(size: 6pt)),
          ((0, 1, 0, 0, 0, 0, 0), none-style(fill: gray)),
        ),
        ratio: 10%,
      ),
    )
  ]

  #only("8")[

    Case 1 : ratio of $~ 2 ceil(N/W)$
    #grid(
      align: (center + bottom),
      columns: (auto, auto),
      im_blocks(
        (
          ((0, 0, 4, 4, 4, 4, 4), none-style()),
          ((4, 3, 0, 0, 0, 0, 0), permutation(id_list: (7, 5, 3, 1, 6, 4, 2), size: 20pt)),
          ((1, 0, 0, 0, 0, 0, 0), none-style()),
        ),
        ratio: 10%,
      ),
      im_blocks(
        (
          ((0, 0, 4, 4, 4, 4, 4), none-style()),
          ((0, 0, 0, 0, 0, 0, 0), request(size: 6pt)),
          ((0, 1, 0, 0, 0, 0, 0), none-style(fill: gray)),
        ),
        ratio: 10%,
      ),
    )
  ]

  #only("9")[

    Case 2 : ratio of $~ W - 1$
    #grid(
      align: (center + bottom),
      columns: (auto, auto),
      im_blocks(
        (
          ((3, 2, 3, 3, 3, 3, 3), none-style()),
          ((1, 1, 1, 1, 1, 1, 1), permutation(id_list: (1, 2, 3, 4, 5, 6, 7), size: 20pt)),
          ((1, 0, 0, 0, 0, 0, 0), none-style()),
        ),
        ratio: 10%,
      ),
      im_blocks(
        (
          ((3, 2, 3, 3, 3, 3, 3), none-style()),
          ((0, 0, 0, 0, 0, 0, 0), request(size: 6pt)),
          ((0, 0, 0, 1, 0, 0, 0), none-style(fill: gray)),
        ),
        ratio: 10%,
      ),
    )
  ]

  #only("10")[
    #theorem-box(title: "Theorem 3")[
      For any algorithm $ALG$, its competitive ratio $c_ALG$ verifies : $c_(ALG) >= min(2 ceil(N/W) - 1, W-1)$
    ]

    #grid(
      columns: (auto, auto),
      im_blocks(
        (
          ((2, 4, 3), permutation(id_list: (4, 2, 5, 3, 1, 6, 9, 8, 7), size: 20pt)),
        ),
        ratio: 12%,
      ),
      im_blocks(
        (
          ((2, 4, 3), permutation(id_list: (6, 3, 7, 4, 1, 9, 8, 5, 2), size: 20pt)),
        ),
        ratio: 12%,
      ),
    )


  ]
])

==

#align(center + horizon)[#text("Thanks for your attention !", size: 40pt)]


== Bibliography


#bibliography("works.bib")
