#import "@preview/cetz:0.4.0": canvas, draw

#let eps = 0.01
#let eps2 = 0.01

#let none-style(fill: none, stroke_ext: 1pt + black) = (
  stroke_ext: stroke_ext,
  fill: fill,
  type: "none",
)

#let request(fill: none, stroke_ext: 1pt + black, size: 1pt, stroke: 2pt + black, fill-in: black) = (
  stroke_ext: stroke_ext,
  fill: fill,
  type: "request",
  stroke: stroke,
  size: size,
  fill-in: fill-in,
)

#let zone(fill: none, stroke_ext: 1pt + black) = (
  stroke_ext: stroke_ext,
  fill: fill,
  type: "zone",
)

#let hachure(
  stroke_ext: 1pt + black,
  stroke: 1pt + black,
  interval: 0.2,
  direction: true,
  fill: none,
) = (
  stroke_ext: stroke_ext,
  stroke: stroke,
  interval: interval,
  fill: fill,
  direction: direction,
  type: "hachure",
)

#let numbered(
  stroke_ext: 1pt + black,
  size: 11pt,
  fill: none,
  fill-nb: black,
  number: 0,
) = (
  stroke_ext: stroke_ext,
  size: size,
  fill: fill,
  fill-nb: fill-nb,
  number: number,
  type: "numbered",
)

#let permutation(
  stroke_ext: 1pt + black,
  fill: none,
  fill-nb: black,
  size: 11pt,
  direction: true,
  id_list: [],
) = (
  stroke_ext: stroke_ext,
  size: size,
  fill: fill,
  fill-nb: fill-nb,
  id_list: id_list,
  type: "permutation",
)

#let draw_block(x, y, fill-style) = {
  import draw: *


  if fill-style.type == "zone" {
    rect(
      (x - eps, y - eps),
      (x + eps + 1, y + eps + 1),
      stroke: fill-style.stroke_ext,
      name: "sq",
      fill: fill-style.fill,
    )
  } else {
    rect((x, y), (x + 1, y + 1), stroke: fill-style.stroke_ext, name: "sq", fill: fill-style.fill)
  }

  if fill-style.type == "hachure" {
    let i = 0
    let start = x - 1
    while start < x + 1 {
      if start <= x {
        line(
          (x, y + (x - start)),
          (start + 1, y + 1),
          stroke: fill-style.stroke,
        )
      } else {
        line(
          (start, y),
          (x + 1, y + x + 1 - start),
          stroke: fill-style.stroke,
        )
      }
      start += fill-style.interval
    }
  } else if fill-style.type == "numbered" {
    content("sq", [#set text(size: fill-style.size, fill: fill-style.fill-nb); $b_(#fill-style.number)$])
  } else if fill-style.type == "request" {
    circle(
      (x + 0.5, y + 0.5),
      fill: fill-style.fill-in,
      stroke: fill-style.stroke,
      radius: (fill-style.size, fill-style.size),
    )
  }
}

#let draw_bot(x, fill-style) = {
  import draw: *
  line((x, 0), (x + 1, 0), stroke: fill-style.stroke_ext, name: "l")
}

#let draw_line(x, y, direction, fill-style) = {
  import draw: *
  line(
    (x, y),
    (x + direction.at(0) * (1 + eps2), y + direction.at(1) * (1 + eps2)),
    stroke: fill-style.stroke_ext,
    name: "l",
  )
}


#let draw_blocks(bay, display-line: true) = {
  import draw: *
  let k = bay.len()
  let n = bay.at(0).at(0).len()
  let height = range(0, n)

  let max_height = 0
  for i in range(0, n) {
    let candidate = 0
    for x in range(0, k) {
      candidate += bay.at(x).at(0).at(i)
    }
    if (candidate > max_height) {
      max_height = candidate
    }
  }

  if (display-line) {
    line((-0.2, 0), (-0.2, max_height), name: "test")
    line((0, -0.2), (n, -0.2), name: "abscisse")
    for i in range(0, max_height) {
      content((name: "test", anchor: 0.5 + i), anchor: "east", padding: 0.2)[#str(i + 1)]
    }
    for i in range(0, n) {
      content((name: "abscisse", anchor: 0.5 + i), anchor: "north", padding: 0.2)[#str(i + 1)]
    }
  }

  for i in range(0, n) {
    height.at(i) = 0
  }
  for i in range(0, k) {
    group = bay.at(i).at(0)
    let fill-style = bay.at(i).at(1)
    let id = 0
    for x in range(0, n) {
      for y in range(height.at(x), height.at(x) + group.at(x)) {
        if fill-style.type == "permutation" {
          draw_block(x, y, numbered(
            size: fill-style.size,
            fill-nb: fill-style.fill-nb,
            fill: fill-style.fill,
            stroke_ext: fill-style.stroke_ext,
            number: fill-style.id_list.at(id),
          ))
          id += 1
        } else if fill-style.type == "zone" {
          draw_block(x, y, zone(fill: fill-style.fill, stroke_ext: none))
        } else {
          draw_block(x, y, fill-style)
        }
      }
    }
    for x in range(0, n) {
      for y in range(height.at(x), height.at(x) + group.at(x)) {
        if fill-style.type == "zone" {
          if x == 0 or height.at(x - 1) > y or y >= height.at(x - 1) + group.at(x - 1) {
            draw_line(x, y, (0, 1), fill-style)
          }
          if x == n - 1 or height.at(x + 1) > y or y >= height.at(x + 1) + group.at(x + 1) {
            draw_line(x + 1, y + 1, (0, -1), fill-style)
          }
          if y == height.at(x) + group.at(x) - 1 {
            draw_line(x, y + 1, (1, 0), fill-style)
          }
          if y == height.at(x) {
            draw_line(x, y, (1, 0), fill-style)
          }
        }
      }
    }


    for x in range(0, n) {
      height.at(x) += group.at(x)
    }
  }
  for i in range(0, n) {
    if height.at(i) == 0 {
      draw_bot(i, none-style())
    }
  }
}

#let custom_im_blocks(bay) = {
  canvas(draw_blocks(bay))
}

#let im_blocks(bay, ratio: 15%, display-line: true) = {
  layout(ly => canvas(length: ratio * ly.width, draw_blocks(bay, display-line: display-line)))
}


#im_blocks((
  ((1, 0, 3, 4), zone(fill: gray)),
  ((10, 0, 1, 1), hachure(stroke: 1pt + red, stroke_ext: (paint: red, thickness: 2pt, dash: "dashed"))),
  ((1, 0, 1, 2), permutation(id_list: (1, 2, 3, 4), fill-nb: green, size: 30pt, fill: gray)),
  ((1, 0, 1, 2), request()),
))




