import sys
input = sys.stdin.readline

w = "sabcabcfabc"


class Node:
    def __init__(self, sub="", children=None):
        self.sub = sub
        self.ch = children or []

class SuffixTree:
    def __init__(self, str):
        self.nodes = [Node()]
        for i in range(len(str)):
            self.addSuffix(str[i:])
    def addSuffix(self, suf):
        n = 0
        i = 0
        while i < len(suf):
            b = suf[i]
            x2 = 0
            while True:
                children = self.nodes[n].ch
                if x2 == len(children):
                    # no matching child, remainder of suf becomes new node
                    n2 = len(self.nodes)
                    self.nodes.append(Node(suf[i:], []))
                    self.nodes[n].ch.append(n2)
                    return
                n2 = children[x2]
                if self.nodes[n2].sub[0] == b:
                    break
                x2 = x2 + 1
            # find prefix of remaining suffix in common with child
            sub2 = self.nodes[n2].sub
            j = 0
            while j < len(sub2):
                if suf[i + j] != sub2[j]:
                    # split n2
                    n3 = n2
                    # new node for the part in common
                    n2 = len(self.nodes)
                    self.nodes.append(Node(sub2[:j], [n3]))
                    self.nodes[n3].sub = sub2[j:] # old node loses the part in common
                    self.nodes[n].ch[x2] = n2
                    break # continue down the tree
                j = j + 1
            i = i + j # advance past part in common
            n = n2 # continue down the tree

L = 11
s = w
sufftree = SuffixTree(s+"$")
for node in sufftree.nodes:
    print(node.sub)


def parcours(tree,id_noeud,length,maxi):
    if tree.nodes[id_noeud].ch == []:
        return 1,maxi
    totalfils=0
    l=length+len(tree.nodes[id_noeud].sub)
    for fils in tree.nodes[id_noeud].ch:
        nbfils,maxi = parcours(tree,fils,l,maxi)
        totalfils+=nbfils
    if totalfils>1:
        maxi=max(maxi,l)
    return totalfils,maxi

fils,maxi = parcours(sufftree,0,0,0)

