def augment(u, bigraph, visit, timestamp, match):
    """ find augmenting path starting from u, by recursive DFS """
    for v in bigraph[u]:
        if visit[v] < timestamp:
            visit[v] = timestamp
            if match[v] is None or augment(match[v], bigraph, visit, timestamp, match):
                match[v] = u # found an augmenting path
                return True
    return False

def max_bipartite_matching(bigraph):
    """Bipartie maximum matching
    :param bigraph: adjacency list, index = vertex in U,
    value = neighbor list in V
    :comment: U and V can have different cardinalities
    :returns: matching list, match[v] == u iff (u, v) in matching
    :complexity: `O(|V|*|E|)`
    """
    nU = len(bigraph) # nU = cardinality of U, nV = card. of V
    nV = max(max(adjlist, default=-1) for adjlist in bigraph) + 1
    match = [None] * nV
    visit = [-1] * nV # timestamp of last visit
    for u in range(nU):
        augment(u, bigraph, visit, u, match)
    return match

n = int(input())
l = []
values = set()
for _ in range(n):
    a,b = list(map(int,input().split()))
    l.append((a,b))
    values.add(a + b)
    values.add(a - b)
    values.add(a * b)

def nb(i):
    a,b = l[i]
    s = set() 
    s.add(a+b)
    s.add(a-b)
    s.add(a*b)
    return s

val_to_id = dict()
id_to_val = dict()
ind = 0
for v in values:
    val_to_id[v] = ind
    id_to_val[ind] = v
    ind += 1

graph = [[] for _ in range(n)]
for i in range(n):
    for v in nb(i):
        graph[i].append(val_to_id[v])

m = max_bipartite_matching(graph)
nb_match = 0
for x in m:
    if not(x is None):
        nb_match += 1
if nb_match < n:
    print("impossible")
else:
    sol = [0 for _ in range(n)]
    for ind_v in range(len(values)):
        if m[ind_v] != None:
            i = m[ind_v]
            sol[i] = id_to_val[ind_v]
    for i in range(n):
        v = sol[i]
        a,b = l[i]
        if a + b == v:
            print(a,"+",b,"=",v)
        elif a - b == v:
            print(a,"-",b,"=",v)
        elif a * b == v:
            print(a,"*",b,"=",v)
