from math import sqrt

def left_turn(a,b,c):
    return (a[0] - c[0]) * (b[1] - c[1]) - (a[1] - c[1]) * (b[0] - c[0]) > 0

def andrew(S):
    S.sort()
    top = []
    bot = []
    for p in S:
        while len(top) >= 2 and not left_turn(p,top[-1],top[-2]):
            top.pop()
        top.append(p)
        while len(bot) >= 2 and not left_turn(bot[-2],bot[-1],p):
            bot.pop()
        bot.append(p)
    return bot[:-1] + top[:0:-1]

N,R = map(int,input().split())
S = []
for _ in range(N):
    x,y = map(int,input().split())
    S.append((x,y))

L = andrew(S)
N = len(L)

def d(a,b):
    return sqrt((a[0] - b[0])**2 + (a[1] - b[1])**2)

def dist(i,j):
    a,b,c = L[i],L[j],L[(j+1)%N]
    A,B,C = d(a,b),d(b,c),d(c,a)
    s = (A+B+C)/2
    area = sqrt(s*(s-A)*(s-B)*(s-C))
    return 2 * area/B



i = 0
maxi = 0
h = 0
for k in range(1,N-1):
    j = (i+k)%N
    a = dist(i,j)
    if a > maxi:
        maxi = a
        h = k
mini = maxi

for i in range(1,N):
    h -= 1
    if h == 0:
        h += 1
    j = (i+h)%N
    a = dist(i,j)
    maxi = a
    while h < N-2:
        b = dist(i,(i+h+1)%N)
        if b > a:
            maxi = b
            a = b
            h += 1
        else:
            break

    if maxi < mini:
        mini = maxi
print(mini)

"""
3 10 
0 0
0 1 
0 2
"""
